// NetProxyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetProxy.h"
#include "NetProxyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID NETPROXY_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[NETPROXY] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 11, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CRect g_rect_channel_window_topology_01_704[ 1 ] = { CRect(       0,       0,       704,       480 )  // FULLSCREEN
};
CRect g_rect_channel_window_topology_04_704[ 4 ] = { CRect(       0,       0,       352,       240 ), // QUAD

													 CRect(     352,       0,       704,       240 ), // QUAD

													 CRect(       0,     240,       352,       480 ), // QUAD

													 CRect(     352,     240,       704,       480 )  // QUAD
};

/////////////////////////////////////////////////////////////////////////////
// CNetProxyDlg dialog

CNetProxyDlg::CNetProxyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetProxyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetProxyDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hNetworkSourceDev[ 0 ] = 0xFFFFFFFF;

	m_hNetworkSourceDev[ 1 ] = 0xFFFFFFFF;

	m_hNetworkSourceDev[ 2 ] = 0xFFFFFFFF;

	m_hNetworkSourceDev[ 3 ] = 0xFFFFFFFF;

	m_nNetworkSourceStreamingState[ 0 ] = 0x00000000;

	m_nNetworkSourceStreamingState[ 1 ] = 0x00000000;

	m_nNetworkSourceStreamingState[ 2 ] = 0x00000000;

	m_nNetworkSourceStreamingState[ 3 ] = 0x00000000;
}

void CNetProxyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetProxyDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNetProxyDlg, CDialog)
	//{{AFX_MSG_MAP(CNetProxyDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_ERASEBKGND()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetProxyDlg message handlers

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetProxyDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetProxyDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CNetProxyDlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
	return TRUE;

	return CDialog::OnEraseBkgnd(pDC);
}

void CNetProxyDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CNetProxyDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL CNetProxyDlg::HwInitialize()
{
	DWORD  dw_ip = 0x00000000;

	USHORT w_port = 0;

	m_oSetupDialog.GetNetworkParameters( &dw_ip, &w_port );

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE NETWORK RESOURCE
	// 
	{	BOOL b_is_connect_success[ 4 ] = { FALSE, FALSE, FALSE, FALSE };
		
		CHAR psz[ MAX_PATH ];

		for( ULONG i = 0 ; i < 4 ; i++ ) {

			sprintf( psz, "Common Analog Network Source url=rtsp://root:root@%d.%d.%d.%d/session%d.mpg", (BYTE)(dw_ip >> 24), (BYTE)(dw_ip >> 16), (BYTE)(dw_ip >> 8), (BYTE)(dw_ip >> 0), i );

		//	sprintf( psz, "Common Analog Network Source url=rtsp://dynamas.com.tw/video1.mpeg4" );

			m_hNetworkSourceDev[ i ] = AMESDK_CREATE( psz, i, 4, 

													  m_oChannelWindow[ i ].m_hWnd, NULL, NULL,   // VIDEO STREAM

													  m_oChannelWindow[ i ].m_hWnd, NULL, NULL ); // AUDIO STREAM

			if( m_hNetworkSourceDev[ i ] & 0x80000000 ) {

				m_hNetworkSourceDev[ i ] = 0xFFFFFFFF;
			}
		}
		for( ULONG t = 0 ; t < 10 ; t++ ) {

			for( i = 0 ; i < 4 ; i++ ) {

				if( b_is_connect_success[ i ] == FALSE ) {

					b_is_connect_success[ i ] = AMESDK_NETWORK_CONNECT_STREAMING_SERVER( m_hNetworkSourceDev[ i ], 0 ); // UDP = 0 / TCP = 1
				}
			}
			if( b_is_connect_success[ 0 ] == FALSE ||

				b_is_connect_success[ 1 ] == FALSE ||

				b_is_connect_success[ 2 ] == FALSE ||

				b_is_connect_success[ 3 ] == FALSE ) {

				Sleep( 1000 );
			}
		}
		for( i = 0 ; i < 4 ; i++ ) {

			if( b_is_connect_success[ i ] == FALSE ) {

				if( m_hNetworkSourceDev[ i ] != 0xFFFFFFFF ) {

					AMESDK_DESTROY( m_hNetworkSourceDev[ i ] );

					m_hNetworkSourceDev[ i ] = 0xFFFFFFFF;
				}
			}
		}
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] STOP STREAMING
	//
	{	m_nNetworkSourceStreamingState[ 0 ] = 0x00000002;

		m_nNetworkSourceStreamingState[ 1 ] = 0x00000002;
		
		m_nNetworkSourceStreamingState[ 2 ] = 0x00000002;
		
		m_nNetworkSourceStreamingState[ 3 ] = 0x00000002;

		AMESDK_RUN( m_hNetworkSourceDev[ 0 ] );

		AMESDK_RUN( m_hNetworkSourceDev[ 1 ] );

		AMESDK_RUN( m_hNetworkSourceDev[ 2 ] );

		AMESDK_RUN( m_hNetworkSourceDev[ 3 ] );
	}

//	CHAR psz[ 256 ] = "456";
//
//	AMESDK_NETWORK_SET_CUSTOM_PROPERTY( m_hNetworkSourceDev[ 0 ], "123", psz, sizeof(psz)  );
//
//	NETPROXY_DEBUG( "%s\n", psz );
//
//	AMESDK_NETWORK_GET_CUSTOM_PROPERTY( m_hNetworkSourceDev[ 0 ], "789", psz, sizeof(psz) );
//
//	NETPROXY_DEBUG( "%s\n", psz );

	return TRUE;
}

BOOL CNetProxyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE USER INTERFACE RESOURCE
	//
	{	CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		SetWindowPos( &(CWnd::wndTop), 0, 0, 704 + (cx), 480 + (cy), SWP_NOMOVE );

		m_oChannelWindow[ 0 ].Create( NULL, "MyChannelWindow#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 0 ], this, 0x00000000, NULL );

		m_oChannelWindow[ 1 ].Create( NULL, "MyChannelWindow#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 1 ], this, 0x00000001, NULL );

		m_oChannelWindow[ 2 ].Create( NULL, "MyChannelWindow#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 2 ], this, 0x00000002, NULL );

		m_oChannelWindow[ 3 ].Create( NULL, "MyChannelWindow#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 3 ], this, 0x00000003, NULL );

		SetTimer( 0x00000000, 0, NULL );
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetProxyDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING
	//
	if( nIDEvent == 0x00000000 ) {

		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

		m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), oWindowRect.left, oWindowRect.bottom - 15 + 5, cx + 704, cx + 22, NULL );

		m_oSetupDialog.ShowWindow( TRUE );

		SetWindowPos( NULL, oWindowRect.left, oWindowRect.top - 15, 0, 0, SWP_NOSIZE | SWP_NOZORDER );

		SetFocus();

		m_oSetupDialog.UpdateWindow();

		KillTimer( 0x00000000 );
	}
	CDialog::OnTimer(nIDEvent);
}

BOOL CNetProxyDlg::HwUnInitialize()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] STOP STREAMING
	//
	{	m_nNetworkSourceStreamingState[ 0 ] = 0x00000000; // STOP STATE

		m_nNetworkSourceStreamingState[ 1 ] = 0x00000000; // STOP STATE

		m_nNetworkSourceStreamingState[ 2 ] = 0x00000000; // STOP STATE

		m_nNetworkSourceStreamingState[ 3 ] = 0x00000000; // STOP STATE

		AMESDK_STOP( m_hNetworkSourceDev[ 0 ] );

		AMESDK_STOP( m_hNetworkSourceDev[ 1 ] );

		AMESDK_STOP( m_hNetworkSourceDev[ 2 ] );

		AMESDK_STOP( m_hNetworkSourceDev[ 3 ] );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE NETWORK RESOURCE
	//
	{	if( m_hNetworkSourceDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hNetworkSourceDev[ 0 ] ); m_hNetworkSourceDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hNetworkSourceDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hNetworkSourceDev[ 1 ] ); m_hNetworkSourceDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hNetworkSourceDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hNetworkSourceDev[ 2 ] ); m_hNetworkSourceDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hNetworkSourceDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hNetworkSourceDev[ 3 ] ); m_hNetworkSourceDev[ 3 ] = 0xFFFFFFFF; }
	}
	return TRUE;
}

void CNetProxyDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUnInitialize();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindow[ 0 ].DestroyWindow();

		m_oChannelWindow[ 1 ].DestroyWindow();

		m_oChannelWindow[ 2 ].DestroyWindow();

		m_oChannelWindow[ 3 ].DestroyWindow();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}
}

BOOL CNetProxyDlg::OnLButtonDown_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING
	//
	if( nChannelNumber == 0x00000000 ||

		nChannelNumber == 0x00000001 ||

		nChannelNumber == 0x00000002 ||

		nChannelNumber == 0x00000003 ) {

		nChannelNumber -= 0x00000000;

		CRect rect;
	
		m_oChannelWindow[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 640 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hNetworkSourceDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hNetworkSourceDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hNetworkSourceDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hNetworkSourceDev[ 3 ] ); }

		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow[ 0 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hNetworkSourceDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow[ 1 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hNetworkSourceDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow[ 2 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hNetworkSourceDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow[ 3 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hNetworkSourceDev[ 3 ] ); }
		}
	}
	return TRUE;
}

BOOL CNetProxyDlg::OnLButtonUp_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point )
{
	return TRUE;
}

BOOL CNetProxyDlg::OnConnect_SetupDialog()
{
	HwUnInitialize();

	HwInitialize();

	m_oChannelWindow[ 0 ].Invalidate();

	m_oChannelWindow[ 1 ].Invalidate();

	m_oChannelWindow[ 2 ].Invalidate();

	m_oChannelWindow[ 3 ].Invalidate();

	return TRUE;
}
