// MySwitchLiveAV.h: interface for the MySwitchLiveAV class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYSWITCHLIVEAV_H__F3270E5E_3368_41F5_9A5E_1E86D0DAE260__INCLUDED_)
#define AFX_MYSWITCHLIVEAV_H__F3270E5E_3368_41F5_9A5E_1E86D0DAE260__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MyAV.h"

#include "MySwEncodeAV.h"

#include "MyHwEncodeAV.h"

#include "MyRecordAV.h"

class MySwitchLiveAV : public MyAV  
{

public:

	MySwitchLiveAV();

	virtual ~MySwitchLiveAV();

	virtual BOOL IsConnected() { return m_bConnect; }
	
	virtual BOOL Connect();	

	virtual BOOL Disconnect();

	void SetChipName(CString strChipName) { m_strChipName = strChipName; }	

	void SetChannelID( UINT nChannelID ) { m_nChannelID = nChannelID; }

	UINT GetChannelID() { return m_nChannelID; }	

	BOOL SetVideoStandard(ULONG nStandard);

	BOOL SetVideoInput(ULONG nInput);

	BOOL SetVideoFormat(ULONG nColorSpaceType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, DOUBLE dFrameRate);	

	BOOL GetVideoFormat(ULONG * pnColorSpaceType, ULONG * pnWidth, ULONG * pnHeight, ULONG * pnBitCount, DOUBLE * pdFrameRate);

	BOOL SetDIDeinterlace( BYTE * pFrameBuffer, ULONG nFrameBufferSize );

	BOOL SetVideoDeinterlace(ULONG nDeinterlace, ULONG nSubChannelNumber = 0);

	BOOL SetVideoProperty(ULONG nProperty, ULONG nValue, ULONG nSubChannelNumber = 0);

	BOOL SetCustomProperty(ULONG nProperty, ULONG nValue);

	BOOL LiveRun();

	BOOL LiveStop();

	BOOL RefreshDisplay( ULONG nSubChannelNumber = 0 );	

	BOOL SnapshotBMP(CHAR *pszFilePathName);

	BOOL SnapshotJPG(CHAR *pszFilePathName, ULONG nQuality);

	BOOL SetSwitchTable( BYTE TABLE[] );
	
	VOID ResetCalFrameRateTimer();

public:

	int				m_nActiveWndID;

	int				m_nSwitchType;    // 0 : N, 1 : D, 2 : Q

	CString			m_strChipName;

	HWND			m_hWnd1;

	HWND			m_hWnd2;

	HWND			m_hWnd3;

	HWND			m_hWnd4;

	MyRecordAV    * m_pRecordAV1;

	MyRecordAV    * m_pRecordAV2;

	MyRecordAV    * m_pRecordAV3;

	MyRecordAV    * m_pRecordAV4;

	MySwEncodeAV  * m_pMySwEncodeAV1;

	MySwEncodeAV  * m_pMySwEncodeAV2;

	MySwEncodeAV  * m_pMySwEncodeAV3;

	MySwEncodeAV  * m_pMySwEncodeAV4;

	ULONG			m_nDropFrame;

	ULONG			m_nWidth;
	
	ULONG			m_nHeight;

	PVOID			m_pCustomChannelWindow1;		// CVRSDK : CHANNEL WINDOW POINTER	

	PVOID			m_pCustomChannelWindow2;		// CVRSDK : CHANNEL WINDOW POINTER	

	PVOID			m_pCustomChannelWindow3;		// CVRSDK : CHANNEL WINDOW POINTER	

	PVOID			m_pCustomChannelWindow4;		// CVRSDK : CHANNEL WINDOW POINTER	

	BOOL			m_bFullScreen;

private:		

	UINT			m_nChannelID;

	DEVICE_HANDLE	m_hVideoDev;

	DEVICE_HANDLE  m_hDeinterlaceVideoDev;
};

#endif // !defined(AFX_MYSWITCHLIVEAV_H__F3270E5E_3368_41F5_9A5E_1E86D0DAE260__INCLUDED_)
