﻿Imports QCAP.NET

Public Class MyVideoInputDlg

    Declare Function OutputDebugString Lib "kernel32" Alias "OutputDebugStringA" (ByVal message As String)

    Public m_pMainForm As MySetupControl

    Public m_hCapDev As UInt32 = 0

    Private Sub MyVideoInputDlg_Shown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown

        If m_hCapDev <> 0 Then

            Dim nInput As UInt32 = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI

            EXPORTS.QCAP_GET_VIDEO_INPUT(m_hCapDev, nInput)

            If nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPOSITE Then

                RadioButtonCOMPOSITE.Checked = True

            End If

            If nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SVIDEO Then

                RadioButtonSVIDEO.Checked = True

            End If

            If nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_HDMI Then

                RadioButtonInputHDMI.Checked = True

            End If

            If nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_D Then

                RadioButtonInputDVI.Checked = True

            End If

            If nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPONENTS Then

                RadioButtonYCBCR.Checked = True

            End If

            If nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_A Then

                RadioButtonRGB.Checked = True

            End If

            If nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI Then

                RadioButtonSDI.Checked = True

            End If

            If nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_AUTO Then

                RadioButtonAUTO.Checked = True

            End If

        End If

    End Sub

    Private Sub MyVideoInputDlg_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    Private Sub MyVideoInputDlg_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

    End Sub

    Private Sub RadioButtonInputHDMI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonInputHDMI.Click

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_HDMI)

        End If

    End Sub

    Private Sub RadioButtonInputDVI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonInputDVI.Click

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_D)

        End If

    End Sub

    Private Sub RadioButtonYCBCR_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonYCBCR.Click

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPONENTS)

        End If

    End Sub

    Private Sub RadioButtonRGB_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonRGB.Click

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_DVI_A)

        End If

    End Sub

    Private Sub RadioButtonSDI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonSDI.Click

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI)

        End If

    End Sub

    Private Sub RadioButtonCOMPOSITE_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonCOMPOSITE.Click

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_COMPOSITE)

        End If

    End Sub

    Private Sub RadioButtonSVIDEO_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonSVIDEO.Click

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SVIDEO)

        End If

    End Sub

    Private Sub RadioButtonAUTO_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonAUTO.Click

        If m_hCapDev <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_AUTO)

        End If

    End Sub

    Private Sub buttonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonOK.Click

        Hide()

    End Sub

End Class